/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import java.util.List;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class MobTooltip
implements IRecipeSlotRichTooltipCallback {
    private final MobEntry entry;

    public MobTooltip(MobEntry entry) {
        this.entry = entry;
    }

    public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        LootDrop lootDrop = this.entry.getDrops().get(Integer.parseInt(recipeSlotView.getSlotName().orElse("0")));
        tooltip.add((FormattedText)lootDrop.toStringTextComponent());
        List<Component> list = this.getToolTip((ItemStack)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient());
        if (list != null) {
            tooltip.addAll(list);
        }
    }

    public List<Component> getToolTip(ItemStack stack) {
        for (LootDrop item : this.entry.getDrops()) {
            if (stack.is(item.item.getItem())) {
                return item.getTooltipText();
            }
            if (!item.canBeCooked() || !stack.is(item.smeltedItem.getItem())) continue;
            return item.getTooltipText(true);
        }
        return null;
    }
}

